; ----------------------------------------------------------------------------
; Grafx.s:
; ----------------------------------------------------------------------------
;				Vocabulaire GRAFX
; ----------------------------------------------------------------------------

.ifdef With::GRAFX_VOC

	.ifdef Included::GRAFX
		verbose 3, "Ajout entête du vocabulaire GRAFX"

		; ----------------------------------------------------------------------------
		; GRAFX
		; ----------------------------------------------------------------------------
		vocabulary_pfa "GRAFX"

	.else
		verbose 3, "Ajout du dictionaire GRAFX"
		Included::GRAFX = 1

		; ----------------------------------------------------------------------------
		; GRAFX
		; ----------------------------------------------------------------------------
		vocabulary"GRAFX",, immediate

		; ----------------------------------------------------------------------------
		; TEXT
		; Appel Telemon XTEXT ($19)
		; ----------------------------------------------------------------------------
		declare "TEXT", "TEXTgrafx"
		        .word   DOMON
		        .byte   XTEXT

		; ----------------------------------------------------------------------------
		; HIRES
		; Appel Telemon XHIRES ($1A)
		; ----------------------------------------------------------------------------
		declare "HIRES"
		        .word   DOMON
		        .byte   XHIRES

		; ----------------------------------------------------------------------------
		; ADRAW
		; ----------------------------------------------------------------------------
		declare "ADRAW"
		        .word   DOHRS
		        .byte   $8D,$84

		; ----------------------------------------------------------------------------
		; DRAW
		; ----------------------------------------------------------------------------
		declare "DRAW"
		        .word   DOHRS
		        .byte   $8E,$82

		; ----------------------------------------------------------------------------
		; CIRCLE
		; ----------------------------------------------------------------------------
		declare "CIRCLE"
		        .word   DOHRS
		        .byte   $8F,$81

		; ----------------------------------------------------------------------------
		; CURSET
		; ----------------------------------------------------------------------------
		declare "CURSET"
		        .word   DOHRS
		        .byte   $90,$82

		; ----------------------------------------------------------------------------
		; CURMOV
		; ----------------------------------------------------------------------------
		declare "CURMOV"
		        .word   DOHRS
		        .byte   $91,$82

		; ----------------------------------------------------------------------------
		; BOX
		; ----------------------------------------------------------------------------
		declare "BOX"
		        .word   DOHRS
		        .byte   $94,$82

		; ----------------------------------------------------------------------------
		; ABOX
		; ----------------------------------------------------------------------------
		declare "ABOX"
		        .word   DOHRS
		        .byte   $95,$84

		; ----------------------------------------------------------------------------
		; PAVE
		; ----------------------------------------------------------------------------
		declare "PAVE"
		        .word   DOHRS
		        .byte   $96,$83

		; ----------------------------------------------------------------------------
		; PAPER
		; ----------------------------------------------------------------------------
		declare "PAPER"
		        .word   DOCOL
		        .word   SWAP
		        .word   AYX
		        .word   TWOSTORE
		        .word   LIT
		        .word   XPAPER
		        .word   MON
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; INK
		; ----------------------------------------------------------------------------
		declare "INK"
		        .word   DOCOL
		        .word   SWAP
		        .word   AYX
		        .word   TWOSTORE
		        .word   LIT
		        .word   XINK
		        .word   MON
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; FB
		; ----------------------------------------------------------------------------
		declare "FB"
		        .word   DOCOL
		        .word   LIT
		        .word   $40
		        .word   USTAR
		        .word   DROP
		        .word   LIT
		        .word   hrsfb
		        .word   CSTORE
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; PATTERN
		; ----------------------------------------------------------------------------
		declare "PATTERN"
		        .word   DOCOL
		        .word   LIT
		        .word   hrspat
		        .word   CSTORE
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; HEMIT
		; ----------------------------------------------------------------------------
		declare "HEMIT"
		        .word   DOCOL
		        .word   AYX
		        .word   CSTORE
		        .word   LIT
		        .word   XCHAR
		        .word   MON
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; HTYPE
		; ----------------------------------------------------------------------------
		declare "HTYPE"
		        .word   DOCOL
		        .word   SWAP
		        .word   AYX
		        .word   TWOSTORE
		        .word   LIT
		        .word   XSCHAR
		        .word   MON
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; ADCHAR
		; ----------------------------------------------------------------------------
		declare "ADCHAR"
		        .word   DOCOL
		        .word   AYX
		        .word   CSTORE
		        .word   LIT
		        .word   ZADCHA
		        .word   MON
		        .word   AYX
		        .word   AT
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; CHAR:
		; ----------------------------------------------------------------------------
		declare "CHAR:", "CHARCOL"
		        .word   DOCOL
		        .word   BUILDS
		        .word   HERE
		        .word   LIT
		        .word   $09
		        .word   ALLOT
		        .word   HERE
		        .word   PDO
		LE4FB:
		        .word   I
		        .word   ONES
		        .word   CSTORE
		        .word   LIT
		        .word   $FFFF
		        .word   PPLOOP
		        .word   LE4FB
		        .word   ZERO
		        .word   CCOMMA
		        .word   DOES
		        .word   AYX
		        .word   STORE
		        .word   LIT
		        .word   XSCRNE
		        .word   MON
		        .word   SEMIS

	.endif

.endif

