; ----------------------------------------------------------------------------
; IOS_minimal.s:
; ----------------------------------------------------------------------------
;				Vocabulaire IOS (minimal)
; ----------------------------------------------------------------------------

.ifdef With::IOS_VOC

	.ifdef Included::IOS
		verbose 3, "Ajout entête du vocabulaire IOS"

		; ----------------------------------------------------------------------------
		; IOS
		; ----------------------------------------------------------------------------
		vocabulary_pfa "IOS"

	.else
		verbose 3, "Ajout du vocabulaire IOS"
		Included::IOS= 1

		; ----------------------------------------------------------------------------
		; IOS
		; ----------------------------------------------------------------------------
		add_to_voc "FORTH"
		vocabulary "IOS",, immediate

		; ----------------------------------------------------------------------------
		; OPCH
		; ----------------------------------------------------------------------------
		declare "OPCH"
		        .word   DOCOL
		        .word   LIT
		        .word   $80
		        .word   OR
		        .word   AYX
		        .word   CSTORE
		        .word   LIT
		        .word   $03
		        .word   ANDforth
		        .word   MON
		        .word   SEMIS
		; ----------------------------------------------------------------------------
		; CLCH
		; ----------------------------------------------------------------------------
		declare "CLCH"
		        .word   DOCOL
		        .word   LIT
		        .word   $80
		        .word   OR
		        .word   AYX
		        .word   CSTORE
		        .word   LIT
		        .word   $03
		        .word   ANDforth
		        .word   LIT
		        .word   $04
		        .word   PLUS
		        .word   MON
		        .word   SEMIS
		; ----------------------------------------------------------------------------
		; KBD:
		; ----------------------------------------------------------------------------
		declare "KBD:", "KBDCOL"
		        .word   DOCOL
		        .word   CREATE
		        .word   CCOMMA
		        .word   PSEMICODE

		DOKBDCOL:
		        stx     _XSAVE
		        ldy     #$02
		        lda     (W),y
		        brk
		       .byte    XGOKBD                    ; Telemon
		        ldx     _XSAVE
		        jmp     NEXT

		; ----------------------------------------------------------------------------
		; QWERTY
		; ----------------------------------------------------------------------------
		declare "QWERTY"
		        .word   DOKBDCOL
		        .byte   $00

		; ----------------------------------------------------------------------------
		; AZERTY
		; ----------------------------------------------------------------------------
		declare "AZERTY"
		        .word   DOKBDCOL
		        .byte   $01

		; ----------------------------------------------------------------------------
		; FRENCH
		; ----------------------------------------------------------------------------
		declare "FRENCH"
		        .word   DOKBDCOL
		        .byte   $02

		; ----------------------------------------------------------------------------
		; ACCENT
		; ----------------------------------------------------------------------------
		declare "ACCENT"
		        .word   DOKBDCOL
		        .byte   $04

		; ----------------------------------------------------------------------------
		; ?TERM
		; ----------------------------------------------------------------------------
		code "?TERM", "QTERM"
		QTERM_pfa:
		        stx     _XSAVE
		        ldx     #$00
		        brk
		       .byte    XTSTBU                    ; Telemon
		        bcs     LEF43
		        iny
		LEF43:
		        tya
		        ldx     _XSAVE
		        jmp     PUSH0A

		; ----------------------------------------------------------------------------
		; CKEY
		; ----------------------------------------------------------------------------
		code "CKEY"
		CKEY_pfa:
		        lda     $0567
		        ora     #$0C
		        sta     CallTel+1
		        jsr     CallTel
		        jmp     PUSH0A

		; ----------------------------------------------------------------------------
		; CEMIT
		; ----------------------------------------------------------------------------
		code "CEMIT"
		CEMIT_pfa:
		        lda     $0567
		        tay
		        ora     #$10
		        sta     CallTel+1
		        lda     BOT,x
		        jsr     CallTel
		        lda     scrX,y
		        ldy     LCA07
		        sta     (UP),y
		        jmp     POP

	.endif

.endif
