;----------------------------------------------------------------------
;			cc65 includes
;----------------------------------------------------------------------
.include "telestrat.inc"

;----------------------------------------------------------------------
;			Orix Kernel includes
;----------------------------------------------------------------------
.include "kernel/src/include/kernel.inc"

;----------------------------------------------------------------------
;			Orix Shell includes
;----------------------------------------------------------------------

;----------------------------------------------------------------------
;			Orix SDK includes
;----------------------------------------------------------------------
.include "macros/SDK.mac"

;----------------------------------------------------------------------
;				Imports
;----------------------------------------------------------------------

;----------------------------------------------------------------------
;				Exports
;----------------------------------------------------------------------
.export PrintAY

;----------------------------------------------------------------------
;				Page Zéro
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; Defines / Constants
;----------------------------------------------------------------------
strlen_max := 80

;----------------------------------------------------------------------
; Variables et buffers
;----------------------------------------------------------------------
.segment "DATA"
	stringBuf: .res strlen_max,0
	.byte $00

;----------------------------------------------------------------------
;				Programme
;----------------------------------------------------------------------
.segment "CODE"
.reloc

;----------------------------------------------------------------------
; PrintAY:
; Affiche une chaine a l'ecran
;
; Entree:
;	AY: Adresse de la chaine
;	X : Longueur de la chaine
;
; Sortie:
;	AY: Inchangés
;	C : -> Ok, 1 -> Longueur > strlen_max
;----------------------------------------------------------------------
.proc PrintAY
	; X: Longueur de la chaine
        cpx #$00
        beq end_ok

	cpx #strlen_max+1
	bcs end

	sty RES
	sta RES+1

	; Sauvegarde AY
;	pha
;	tya
;	pha

        ldy #$00

    loop:
        lda (RES),y
        sta stringBuf,y
        beq eos
        iny
        dex
        bne loop

    eos:
        txa
        sta stringBuf,y

	print stringBuf, NOSAVE

	; Restaure AY
;	pla
;	tay
;	pla
	ldy RES
	lda RES+1

    end_ok:
	clc

    end:
	rts
.endproc

