#define CURL_MAX_LENGTH_HOSTNAME 20
#define CURL_MAX_LENGTH_URI      40
#define CURL_MAX_LENGTH_PORT           5
#define CURL_MAX_LENGTH_PROTOCOL       8 // Ex : https://
#define CURL_MAX_LENGTH_SEPARATOR_URL  1 // Ex : ':' port port

#define CURL_MAX_LENGTH_URL CURL_MAX_LENGTH_HOSTNAME + CURL_MAX_LENGTH_URI + CURL_MAX_LENGTH_PORT + CURL_MAX_LENGTH_PROTOCOL + CURL_MAX_LENGTH_SEPARATOR_URL

typedef enum {
    CURLPROTO_HTTP, // Move to have quicker search
    CURLPROTO_DICT,
    CURLPROTO_FILE,
    CURLPROTO_FTP,
    CURLPROTO_FTPS,
    CURLPROTO_GOPHER,
    CURLPROTO_HTTPS,
    CURLPROTO_IMAP,
    CURLPROTO_IMAPS,
    CURLPROTO_LDAP,
    CURLPROTO_LDAPS,
    CURLPROTO_POP3,
    CURLPROTO_POP3S,
    CURLPROTO_RTMP,
    CURLPROTO_RTMPE,
    CURLPROTO_RTMPS,
    CURLPROTO_RTMPT,
    CURLPROTO_RTMPTE,
    CURLPROTO_RTMPTS,
    CURLPROTO_RTSP,
    CURLPROTO_SCP,
    CURLPROTO_SFTP,
    CURLPROTO_SMB,
    CURLPROTO_SMBS,
    CURLPROTO_SMTP,
    CURLPROTO_SMTPS,
    CURLPROTO_TELNET,
    CURLPROTO_TFTP,
    CURLPROTO_UNKNOWN
} CURLprotocol;

typedef enum {
  CURLINFO_PROTOCOL, //  WARN ! will be deprecated !  Protocole utilisé pour la dernière transaction.
  CURLINFO_SCHEME,
  CURLINFO_EFFECTIVE_URL, // URL effective utilisée dans la dernière transaction.
  CURLINFO_RESPONSE_CODE, // Code de réponse HTTP de la dernière transaction.
  CURLINFO_TOTAL_TIME, // Temps total de la dernière transaction, en secondes.
  CURLINFO_NAMELOOKUP_TIME, // Temps passé à résoudre le nom de domaine, en secondes.
  CURLINFO_CONNECT_TIME, // Temps passé à établir la connexion, en secondes.
  CURLINFO_PRETRANSFER_TIME, // Temps passé avant le début du transfert de données, en secondes.
  CURLINFO_STARTTRANSFER_TIME, // Temps passé avant le début du transfert de données, en secondes.
  CURLINFO_SIZE_UPLOAD, // Taille totale des données téléchargées.
  CURLINFO_SIZE_DOWNLOAD, // Taille totale des données téléchargées.
  CURLINFO_SPEED_DOWNLOAD, // Vitesse moyenne de téléchargement, en octets par seconde.
  CURLINFO_SPEED_UPLOAD, // Vitesse moyenne de téléchargement, en octets par seconde.
  CURLINFO_HEADER_SIZE, // Taille de l'en-tête de réponse HTTP.
  CURLINFO_REQUEST_SIZE, // Taille de la requête HTTP envoyée.
  CURLINFO_SSL_VERIFYRESULT, // Résultat de la vérification SSL.
  CURLINFO_FILETIME, // Temps de modification du fichier distant, si disponible.
  CURLINFO_CONTENT_LENGTH_DOWNLOAD, // Taille du contenu téléchargé, si connue.
  CURLINFO_CONTENT_LENGTH_UPLOAD, // Taille du contenu téléchargé, si connue.
  CURLINFO_CONTENT_TYPE, // Type de contenu de la réponse HTTP.
  CURLINFO_REDIRECT_COUNT, // Nombre de redirections suivies.
  CURLINFO_REDIRECT_URL, // URL vers laquelle la dernière redirection a été faite.
  CURLINFO_PRIMARY_IP, // Adresse IP du serveur principal.
  CURLINFO_PRIMARY_PORT, // Port du serveur principal.
  CURLINFO_LOCAL_IP, // Adresse IP locale utilisée pour la connexion.
  CURLINFO_LOCAL_PORT, // Port local utilisé pour la connexion.
  CURLINFO_HTTP_CONNECTCODE, // Code de réponse HTTP de la requête CONNECT utilisée pour les tunnels proxy.
  CURLINFO_HTTPAUTH_AVAIL, // Méthodes d'authentification HTTP disponibles.
  CURLINFO_PROXYAUTH_AVAIL, // Méthodes d'authentification proxy disponibles.
  CURLINFO_OS_ERRNO, // Numéro d'erreur du système d'exploitation.
  CURLINFO_NUM_CONNECTS, // Nombre de connexions établies.
  CURLINFO_SSL_ENGINES, // Moteurs SSL disponibles.
  CURLINFO_COOKIELIST, // Liste des cookies.
  CURLINFO_LASTSOCKET, // Dernier socket utilisé.
  CURLINFO_FTP_ENTRY_PATH, // Chemin d'accès au répertoire FTP.
  CURLINFO_REDIRECT_TIME, // Temps total passé en redirections, en secondes.
  CURLINFO_APPCONNECT_TIME, // Temps passé à établir la connexion SSL/SSH, en secondes.
  CURLINFO_CERTINFO, // Informations sur le certificat SSL.
  CURLINFO_CONDITION_UNMET, // Indique si une condition n'a pas été remplie.
  CURLINFO_RTSP_SESSION_ID, // ID de session RTSP.
  CURLINFO_RTSP_CLIENT_CSEQ, // Numéro de séquence client RTSP.
  CURLINFO_RTSP_SERVER_CSEQ, // Numéro de séquence serveur RTSP.
  CURLINFO_RTSP_CSEQ_RECV, // Numéro de séquence reçu RTSP.
  CURLINFO_CONTENT_LENGTH_DOWNLOAD_T, // Taille du contenu téléchargé, en type curl_off_t.
  CURLINFO_CONTENT_LENGTH_UPLOAD_T, // Taille du contenu téléchargé, en type curl_off_t.
  CURLINFO_SIZE_UPLOAD_T, // Taille totale des données téléchargées, en type curl_off_t.
  CURLINFO_SIZE_DOWNLOAD_T, // Taille totale des données téléchargées, en type curl_off_t.
  CURLINFO_SPEED_DOWNLOAD_T, // Vitesse moyenne de téléchargement, en type curl_off_t.
  CURLINFO_SPEED_UPLOAD_T, // Vitesse moyenne de téléchargement, en type curl_off_t.
  CURLINFO_HOST, // ; Warn is not in original curl.h (linux) but needed for orix lib
  //CURLINFO_URI, // ; Warn is not in original curl.h (linux) but needed for orix lib
} CURLINFO;


typedef enum {
  CURLE_OK = 0,
  CURLE_UNSUPPORTED_PROTOCOL,      /* 1 */
//   CURLE_FAILED_INIT,             /* 2 */
   CURLE_URL_MALFORMAT,           /* 3 */
//   CURLE_NOT_BUILT_IN,            /* 4 - [was obsoleted in August 2007 for
//                                     7.17.0, reused in April 2011 for 7.21.5] */
//   CURLE_COULDNT_RESOLVE_PROXY,   /* 5 */
//   CURLE_COULDNT_RESOLVE_HOST,    /* 6 */
     CURLE_COULDNT_CONNECT,         /* 7 */
//   CURLE_WEIRD_SERVER_REPLY,      /* 8 */
//   CURLE_REMOTE_ACCESS_DENIED,    /* 9 a service was denied by the server
//                                     due to lack of access - when login fails*/
//   CURLE_FTP_ACCEPT_FAILED,       /* 10 - [was obsoleted in April 2006 for
//                                     7.15.4, reused in Dec 2011 for 7.24.0]*/
//   CURLE_FTP_WEIRD_PASS_REPLY,    /* 11 */
//   CURLE_FTP_ACCEPT_TIMEOUT,      /* 12 - timeout occurred accepting server
//                                     [was obsoleted in August 2007 for 7.17.0,
//                                     reused in Dec 2011 for 7.24.0]*/
//   CURLE_FTP_WEIRD_PASV_REPLY,    /* 13 */
//   CURLE_FTP_WEIRD_227_FORMAT,    /* 14 */
//   CURLE_FTP_CANT_GET_HOST,       /* 15 */
//   CURLE_HTTP2,                   /* 16 - A problem in the http2 framing layer.
//                                     [was obsoleted in August 2007 for 7.17.0,
//                                     reused in July 2014 for 7.38.0] */
//   CURLE_FTP_COULDNT_SET_TYPE,    /* 17 */

//   CURLE_PARTIAL_FILE,            /* 18 */
//   CURLE_FTP_COULDNT_RETR_FILE,   /* 19 */
//   CURLE_OBSOLETE20,              /* 20 - NOT USED */
//   CURLE_QUOTE_ERROR,             /* 21 - quote command failure */
//   CURLE_HTTP_RETURNED_ERROR,     /* 22 */
//   CURLE_WRITE_ERROR,             /* 23 */
//   CURLE_OBSOLETE24,              /* 24 - NOT USED */
//   CURLE_UPLOAD_FAILED,           /* 25 - failed upload "command" */
//   CURLE_READ_ERROR,              /* 26 - couldn't open/read from file */
//   CURLE_OUT_OF_MEMORY,           /* 27 */
//   /* Note: CURLE_OUT_OF_MEMORY may sometimes indicate a conversion error
//            instead of a memory allocation error if CURL_DOES_CONVERSIONS
//            is defined
//   */
//   CURLE_OPERATION_TIMEDOUT,      /* 28 - the timeout time was reached */
//   CURLE_OBSOLETE29,              /* 29 - NOT USED */
//   CURLE_FTP_PORT_FAILED,         /* 30 - FTP PORT operation failed */
//   CURLE_FTP_COULDNT_USE_REST,    /* 31 - the REST command failed */
//   CURLE_OBSOLETE32,              /* 32 - NOT USED */
     CURLE_RANGE_ERROR,             /* 33 - RANGE "command" didn't work */
//   CURLE_HTTP_POST_ERROR,         /* 34 */
//   CURLE_SSL_CONNECT_ERROR,       /* 35 - wrong when connecting with SSL */
//   CURLE_BAD_DOWNLOAD_RESUME,     /* 36 - couldn't resume download */
//   CURLE_FILE_COULDNT_READ_FILE,  /* 37 */
//   CURLE_LDAP_CANNOT_BIND,        /* 38 */
//   CURLE_LDAP_SEARCH_FAILED,      /* 39 */
//   CURLE_OBSOLETE40,              /* 40 - NOT USED */
//   CURLE_FUNCTION_NOT_FOUND,      /* 41 - NOT USED starting with 7.53.0 */
//   CURLE_ABORTED_BY_CALLBACK,     /* 42 */
//   CURLE_BAD_FUNCTION_ARGUMENT,   /* 43 */
//   CURLE_OBSOLETE44,              /* 44 - NOT USED */
//   CURLE_INTERFACE_FAILED,        /* 45 - CURLOPT_INTERFACE failed */
//   CURLE_OBSOLETE46,              /* 46 - NOT USED */
//   CURLE_TOO_MANY_REDIRECTS,      /* 47 - catch endless re-direct loops */
    CURLE_UNKNOWN_OPTION,          /* 48 - User specified an unknown option */
//CURLE_SETOPT_OPTION_SYNTAX,    /* 49 - Malformed setopt option */
//   CURLE_OBSOLETE50,              /* 50 - NOT USED */
//   CURLE_OBSOLETE51,              /* 51 - NOT USED */
//   CURLE_GOT_NOTHING,             /* 52 - when this is a specific error */
//   CURLE_SSL_ENGINE_NOTFOUND,     /* 53 - SSL crypto engine not found */
//   CURLE_SSL_ENGINE_SETFAILED,    /* 54 - can not set SSL crypto engine as*/


//   CURLE_SEND_ERROR,              /* 55 - failed sending network data */
//   CURLE_RECV_ERROR,              /* 56 - failure in receiving network data */
//   CURLE_OBSOLETE57,              /* 57 - NOT IN USE */
//   CURLE_SSL_CERTPROBLEM,         /* 58 - problem with the local certificate */
//   CURLE_SSL_CIPHER,              /* 59 - couldn't use specified cipher */
//   CURLE_PEER_FAILED_VERIFICATION, /* 60 - peer's certificate or fingerprint
//                                      wasn't verified fine */
//   CURLE_BAD_CONTENT_ENCODING,    /* 61 - Unrecognized/bad encoding */
//   CURLE_LDAP_INVALID_URL,        /* 62 - Invalid LDAP URL */
//   CURLE_FILESIZE_EXCEEDED,       /* 63 - Maximum file size exceeded */
//   CURLE_USE_SSL_FAILED,          /* 64 - Requested FTP SSL level failed */
//   CURLE_SEND_FAIL_REWIND,        /* 65 - Sending the data requires a rewind
//                                     that failed */
//   CURLE_SSL_ENGINE_INITFAILED,   /* 66 - failed to initialise ENGINE */
//   CURLE_LOGIN_DENIED,            /* 67 - user, password or similar was not
//                                     accepted and we failed to login */
//   CURLE_TFTP_NOTFOUND,           /* 68 - file not found on server */
//   CURLE_TFTP_PERM,               /* 69 - permission problem on server */
//   CURLE_REMOTE_DISK_FULL,        /* 70 - out of disk space on server */
//   CURLE_TFTP_ILLEGAL,            /* 71 - Illegal TFTP operation */
//   CURLE_TFTP_UNKNOWNID,          /* 72 - Unknown transfer ID */
//   CURLE_REMOTE_FILE_EXISTS,      /* 73 - File already exists */
//   CURLE_TFTP_NOSUCHUSER,         /* 74 - No such user */
//   CURLE_CONV_FAILED,             /* 75 - conversion failed */
//   CURLE_CONV_REQD,               /* 76 - caller must register conversion
//                                     callbacks using curl_easy_setopt options
//                                     CURLOPT_CONV_FROM_NETWORK_FUNCTION,
//                                     CURLOPT_CONV_TO_NETWORK_FUNCTION, and
//                                     CURLOPT_CONV_FROM_UTF8_FUNCTION */
//   CURLE_SSL_CACERT_BADFILE,      /* 77 - could not load CACERT file, missing
//                                     or wrong format */
//   CURLE_REMOTE_FILE_NOT_FOUND,   /* 78 - remote file not found */
//   CURLE_SSH,                     /* 79 - error from the SSH layer, somewhat
//                                     generic so the error message will be of
//                                     interest when this has happened */

//   CURLE_SSL_SHUTDOWN_FAILED,     /* 80 - Failed to shut down the SSL
//                                     connection */
//   CURLE_AGAIN,                   /* 81 - socket is not ready for send/recv,
//                                     wait till it's ready and try again (Added
//                                     in 7.18.2) */
//   CURLE_SSL_CRL_BADFILE,         /* 82 - could not load CRL file, missing or*/
//   CURLE_SSL_CRL_BADFILE,         /* 82 - could not load CRL file, missing or
//                                     wrong format (Added in 7.19.0) */
//   CURLE_SSL_ISSUER_ERROR,        /* 83 - Issuer check failed.  (Added in
//                                     7.19.0) */
//   CURLE_FTP_PRET_FAILED,         /* 84 - a PRET command failed */
//   CURLE_RTSP_CSEQ_ERROR,         /* 85 - mismatch of RTSP CSeq numbers */
//   CURLE_RTSP_SESSION_ERROR,      /* 86 - mismatch of RTSP Session Ids */
//   CURLE_FTP_BAD_FILE_LIST,       /* 87 - unable to parse FTP file list */
//   CURLE_CHUNK_FAILED,            /* 88 - chunk callback reported error */
//   CURLE_NO_CONNECTION_AVAILABLE, /* 89 - No connection available, the
//                                     session will be queued */
//   CURLE_SSL_PINNEDPUBKEYNOTMATCH, /* 90 - specified pinned public key did not
//                                      match */
//   CURLE_SSL_INVALIDCERTSTATUS,   /* 91 - invalid certificate status */
//   CURLE_HTTP2_STREAM,            /* 92 - stream error in HTTP/2 framing layer
//                                     */
//   CURLE_RECURSIVE_API_CALL,      /* 93 - an api function was called from
//                                     inside a callback */
//   CURLE_AUTH_ERROR,              /* 94 - an authentication function returned an
//                                     error */
//   CURLE_HTTP3,                   /* 95 - An HTTP/3 layer problem */
//   CURLE_QUIC_CONNECT_ERROR,      /* 96 - QUIC connection error */
//   CURLE_PROXY,                   /* 97 - proxy handshake error */
//   CURLE_SSL_CLIENTCERT,          /* 98 - client-side certificate required */
  CURLE_TOO_LARGE,               /* 100 - a value/data met its maximum */

//   CURL_LAST /* never use! */
} CURLcode;

struct Curl_easy {
    unsigned char stub;
    // char hostname[CURL_MAX_LENGTH_HOSTNAME];
    // unsigned char sockfd;
    // unsigned int dest_port;
    // unsigned long ip_dest;
    // char uri[CURL_MAX_LENGTH_URI];
    // unsigned int curl_opt_ptr; // For instance only fp
    // unsigned char curl_opt;
    // unsigned char protocol; // Protocol
    // unsigned int number_bytes_received;
    // unsigned char content_length_string[8];
    // unsigned char content_length_int[4];
    // unsigned char __internal[4]; // For internal curllib purposes
};

typedef enum {
    CURLOPT_WRITEDATA = 1,
    CURLOPT_URL       = 2,
    CURLOPT_PORT      = 3, //   /* Port number to connect to, if other than default. */
    CURLOPT_HEADER    = 4,
    CURLOPT_VERBOSE   = 8,
    CURLOPT_DRYRUN    = 16,
} CURLoption;

typedef struct Curl_easy CURL;

CURL *curl_easy_init();

CURLcode curl_easy_setopt(CURL *handle, CURLoption option, void *parameter);
CURLcode curl_easy_perform(CURL *easy_handle);
const char *curl_easy_strerror(CURLcode errornum);
void curl_easy_cleanup(CURL *handle);
char *curl_version();

CURLcode curl_easy_getinfo(CURL *curl, CURLINFO info, void *parameter);
