[![Build Status](https://travis-ci.org/oric-software/orix.svg?branch=master)](https://travis-ci.org/oric-software/orix)

# Orix

## Introduction

Orix is designed to work with ORICHD (telestrat) and Twilighte card (atmos). See : http://orix.oric.org

Some code is done by Fabrice Broche (70%) and Jede (30%). Anyway, all minitel and FDC routines had been removed

Assembler : XA
CPU : 6502 & 65C02 (not tested)

## How to code in the kernel.

* There is 3 banks
  src/bank7.asm is the primitive bank, each time a BRK is called, it switch to this bank
  src/bank6.asm contains a modifyied atmos rom (some bytes are changed, and there is not test rom)
  src/bank5.asm contains functions and interpreter

* 6502 & 65C02
 for specific 65C02 code, please use #ifdef CPU_65C02

 example : 
#ifdef CPU_65C02
    bra next
#else
    ; 6502 only
    jmp next
#endif


* Optimizing code  
1) use 'jsr' when you are in 7th bank (main bank)

* new hardware
If you implement new hardware in the kernel, please use #ifdef WITH_XXX

If you manage FDC :

#ifdef WITH_FDC1793
Bla
#else
#endif

* register a command in Orix
1) create a file called "src/orix/commands/YOURcommand.asm"
2) in this file do the code of your command :

_mycommand
.(
	rts
.)
3) register the command in Orix :
a) in bank5.asm

increment the value of : 

#define BASH_NUMBER_OF_COMMANDS

b) in bank5.asm

search : 
#include "src/orix/commands/echo.asm"

and add your code :

#include "src/orix/commands/MYCOMMAND.asm"

c) in bank5

add the name of your command. Search :

cat
    .asc "cat",0

and add in alphabetical order :

mycommand
    .asc "mycommand",0

d) in bank5
search 'commands_low'

add in alphabetical order your command :

.byt <_mycommand ; code vector 

e) in bank5
search 'commands_high'

add in alphabetical order your command :

.byt >_mycommand ; code vector

f) in bank5
search 'list_command_low'

add in alphabetical order your command :

.byt <mycommand ; string of the command

g) in bank 5
search 'list_command_high'

add in alphabetical order your command :

.byt >mycommand ; string of the command

h) 
search 'commands_length'

add in alphabetical order your command :

.byt X ; the size of the string command (command 'debug' : X will be equal to 5)

i) build orix

j) if you type help, you should see your command in alphabetical order

h) if you launch your command, it will work, it's not the case, you did not do the alphabetical order above.













## Timeline

### 2017-09-24

* corrections de 2 bugs sur la lecture du fichier (l'un pour dans le cas d'une lecture d'une taille vide et donc dépassement de buffer : acceleration de la lecture) (bugs trouvés par Assinie)
* passage de certains headers (telemon.h, 6522_1.h, 6522_2.h) qui étaient dans Oric-common, dans le repo telemon.
* passage des variables telemon dans le repo telemon (avant : dans oric-common)
* nettoyage des appels au FDC (orix devrait démarrer plus vite ainsi que telemon)
* ajout d'une primitive : XVARS qui permet de récupérer certaines adresses de telemon (pour l'instant, il est possible de récupérer que l'adresse du PWD). Ceci permettra d'avoir des binaires compatibles avec différentes versions de telemon.
* gestion dans la fonction XREAD du 65C02 qui devrait légèrement accélérer la lecture quand telemon est assemblé pour le 65C02 avec un 65C02 embarqué.
* correction du bug du XCLOSE qui n'était pas implémenté à la fin du chargement de binaire, ce qui laissait ouvert /bin. Ce bug était connu car XCLOSE faisait planter ORICHD, dès que la primitive était appelée. XCLOSE ne fait plus planter ORICHD

### 2017-03-17
* fread/fopen/fclose are working
* fwrite is working at 50%
* build info added (date)

### 2016-10-09
* Working on 3.0 version : adding fread/fopen from usb key
* some minitel routines are removed
* some 65C02 code

### 2016-07-02
2.4 version is finished. Some labels are missing (Page 0, page 2 etc has still the true address). But it's working.
Hash of generated file of this version : 9a432244d9ee4a49e8ddcde64af94e05

### 2016-06-30
2.4 version is almost disassembled. Some labels are missing (Page 0, page 2 etc has still the true address)

##How to build a version ?

###For 2.4
* clone this repo with 2.4 branch
* edit build.bat and change "OSDKB" value to the xa.exe (6502 assembler) path, and "ORICUTRON" value to your own oricutron path if you want to copy the version in oricutron ROM. You have to change the path of the ROM file in oricutron.cfg
 

## Features

### 2.5 version : what's new ?
 * all minitel routines removed
 * all minitel keyboard shortcuts removed (used in minitel mode)
 * all minitel primitives related removed

### 2.4 version
Read books released in 1986 on the telestrat :) !

# help
# uname -a
# clear 
# help
# mkdir /etc
# cd /etc
# pwd
# touch orixcfg.cnf
# vi orixcfg.cnf
# cat orixcfg.cnf
# rm
# rm ffdsfds
# rm orixcfg.cnf
# ls 
# man 4kkong
# cd ..
# cd /usr/bin/
# ./4kkong
# date
# echo Hello!
# ipkg list
# file stormld.wav
# file toto.gz
# gunzip toto.gz
# ls
# meminfo
# cd /usr/share/doc/rambo
# cat readme.md
# tgi






 

Goal : trying to change some features
