
#define BRK_TELEMON(value)\
  .byt 00,value;

#define BRK_ORIX(value)\
  .byt 00,value;
  
#define RETURNVAL(value)\
  lda #value:\
  sta ERRNO
  
#define RETURN0\
  lda #$00:\
  sta ERRNO  

#define PRINT_BINARY_TO_DECIMAL_16BITS(justif)\
  LDX #$20:\
  STX DEFAFF:\
  LDX #justif:\
  BRK_ORIX(XDECIM)

#define CLS\
  lda     #<$BB80:\
  ldy     #>$BB80:\
  sta     RES:\
  sty     RES+1:\
  ldy     #<($BB80+40+27*40):\
  ldx     #>($BB80+40+27*40):\
  lda     #" ":\
  BRK_ORIX(XFILLM)
  
#define UNREGISTER_PROCESS\
  lda ORIX_CURRENT_PROCESS_FOREGROUND:\
  beq skip_UNREGISTER_PROCESS:\
  jsr _orix_unregister_process:\
skip_UNREGISTER_PROCESS

#define UNREGISTER_PROCESS_BY_PID_IN_ACCUMULATOR\
  beq skip_UNREGISTER_PROCESS:\
  jsr _orix_unregister_process:\
skip_UNREGISTER_PROCESS
 
#define SWITCH_ON_CURSOR()\
  ldx #$00:\
  BRK_ORIX(XCSSCR)

#define SWITCH_OFF_CURSOR()\
ldx #$00:\
BRK_ORIX(XCOSCR)

#define HIRES()\
  BRK_ORIX(XHIRES)

#define REGISTER_PROCESS(str_name_process)\
    lda #<str_name_process:\
    ldy #>str_name_process:\
    jsr _orix_register_process  
   
  
; O_WRONLY
; O_RDONLY   
#define FOPEN(file,mode)\
  lda   #<file:\
  ldx   #>file:\
  ldy   #mode:\
  BRK_ORIX(XOPEN)
  
#define FOPEN_INTO_BANK7(file,mode)\
  lda   #<file:\
  ldx   #>file:\
  ldy   #mode:\
  jsr   XOPEN_ROUTINE
  

#define MKDIR(PATH)\
  lda   #<PATH:\
  ldx   #>PATH:\
  BRK_ORIX(XMKDIR)
  
// size_t fread ( void * ptr, size_t size, FILE * stream);  
#define FREAD(ptr,size,count,fp)\
    lda #<fp:\
    lda #>fp:\
    lda #<ptr:\
    sta PTR_READ_DEST:\
    lda #>ptr:\
    sta PTR_READ_DEST+1:\
    lda #<size:\
    ldy #>size:\
    BRK_ORIX(XFREAD)  
  
#define MALLOC(size)\
  lda #<size:\
  ldy #>size:\
  BRK_ORIX(XMALLOC)

#define FREE(ptr)\
  lda #<ptr:\
  ldy #>ptr:\
  BRK_ORIX(XFREE)

#define CPUTC(char)\
  lda #char:\
  BRK_ORIX(XWR0)
  
#define PRINT_CHAR(str)\
  pha:\
  sta TR6:\
  txa:\
  pha:\
  tya:\
  pha:\
  lda TR6:\
  BRK_TELEMON(XWR0):\
  pla:\
  tay:\
  pla:\
  txa:\
  pla	

#define PRINT(str)\
	pha:\
	txa:\
	pha:\
	tya:\
	pha:\
	lda #<str:\
	ldy #>str:\
	BRK_TELEMON(XWSTR0):\
  pla:\
	tay:\
	pla:\
	txa:\
  pla		

#define RETURN_LINE_INTO_TELEMON\
	pha:\
	txa:\
	pha:\
	tya:\
	pha:\
	lda RES:\
	pha:\
	lda RES+1:\
	pha:\
	jsr XCRLF_ROUTINE : \
	pla:\
	sta RES+1:\
	pla:\
	sta RES:\
	pla:\
	tay:\
	pla:\
	txa:\
	pla
	
#define PRINT_INTO_TELEMON(str)\
	pha:\
	txa:\
	pha:\
	tya:\
	pha:\
	lda RES:\
	pha:\
	lda RES+1:\
	pha:\
	lda #<str:\
	ldy #>str:\
	jsr XWSTR0_ROUTINE : \
	pla:\
	sta RES+1:\
	pla:\
	sta RES:\
	pla:\
	tay:\
	pla:\
	txa:\
	pla

#define RETURN_LINE\
  BRK_ORIX(XCRLF)
	
#define STRCPY(str1,str2)\
	lda #<str1:\
	sta RES:\
	lda #>str1:\
	sta RES+1:\
	lda #<str2:\
	sta RESB:\
	lda #>str2:\
	sta RESB+1:\
	jsr _strcpy

#define STRCAT(str1,str2)\
	lda #<str1:\
	sta RES:\
	lda #>str1:\
	sta RES+1:\
	lda #<str2:\
	sta RESB:\
	lda #>str2:\
	sta RESB+1:\
	jsr _strcat  
	
// This macro copy AY address to str
#define  STRCPY_BY_AY_SRC(str)\
	sta RES:\
	sty RES+1:\
	lda #<str:\
	sta RESB:\
	lda #>str:\
	sta RESB+1:\
	jsr _strcpy
  
