#include "src/include/ch376.h"
#include "src/include/6522_1.h"
#include "src/include/6522_2.h"
#include "src/include/orix.h"
#include "src/include/keyboard.h"
#include "src/include/macro.h"
#include "src/include/orix_vars.inc.asm"

#define CALL_TELEMON_XMINMA\
BRK_ORIX(XMINMA)

#define CH376_ERROR_VERBOSE

#ifdef WITH_LSOF
#define LSOF 1
#else
#define LSOF 0
#endif

#ifdef WITH_MOUNT
#define MOUNT 1
#else
#define MOUNT 0
#endif

#ifdef WITH_DEBUG
#define DEBUG 1
#else
#define DEBUG 0
#endif

#ifdef WITH_DF
#define DF 1
#else
#define DF 0
#endif

#ifdef WITH_VI
#define VI 1
#else
#define VI 0
#endif

#ifdef WITH_SEDSD
#define SEDSD 1
#else
#define SEDSD 0
#endif

#ifdef WITH_TREE
#define TREE 1
#else
#define TREE 0
#endif

#ifdef WITH_SH
#define SH 1
#else
#define SH 0
#endif

#ifdef WITH_MORE
#define MORE 1
#else
#define MORE 0
#endif

#ifdef WITH_LESS
#define LESS 1
#else
#define LESS 0
#endif

#ifdef WITH_CPUINFO
#define CPUINFO 1
#else
#define CPUINFO 0
#endif

#ifdef WITH_BANKS
#define BANKS 1
#else
#define BANKS 0
#endif

#ifdef WITH_KILL
#define KILL 1
#else
#define KILL 0
#endif

#ifdef WITH_HISTORY
#define HISTORY 1
#else
#define HISTORY 0
#endif

#ifdef WITH_XORIX
#define XORIX 1
#else
#define XORIX 0
#endif

#define BASH_NUMBER_OF_COMMANDS 27+LSOF+DF+VI+TREE+SH+MORE+LESS+SEDSD+CPUINFO+BANKS+KILL+HISTORY+XORIX+MOUNT

#define COLOR_FOR_FILES             $87 // colors when ls displays files 
#define COLOR_FOR_DIRECTORY         $86 // colors when ls display directory
	
.text	
  *=$C000
start_orix

    ; set lowercase keyboard should be move in telemon bank
    lda FLGKBD
    and #%00111111 ; b7 : lowercase, b6 : no sound
    sta FLGKBD

  ; Init PID tables
  .(
    lda #$00
    ldx #ORIX_MAX_PROCESS
  loop
    sta LIST_PID,x
    dex
    bpl loop
  .)

  ; register kernel

/**************************************************************************************************************************/
/*                                                     Register in process list 'init' process                            */
/**************************************************************************************************************************/
  
    ldx #$00              ; PID father
    REGISTER_PROCESS(process_init)

    tax                    ; get init PID for PID father 

/**************************************************************************************************************************/
/*                                                     Register in process list 'bash' process                            */
/**************************************************************************************************************************/    
    
    REGISTER_PROCESS(process_bash)

/**************************************************************************************************************************/
/*                                                     init malloc table in memory                                        */
/**************************************************************************************************************************/    
  
; new init malloc table 
    lda #<orix_end_memory_kernel              ; First byte available when Orix Kernel has started
    sta ORIX_MALLOC_FREE_BEGIN_LOW_TABLE      ; store it malloc table (low)
    lda #>orix_end_memory_kernel
    sta ORIX_MALLOC_FREE_BEGIN_HIGH_TABLE     ; and High
    
    lda #<ORIX_MALLOC_MAX_MEM_ADRESS          ; Get the max memory adress (in oric.h)
    sta ORIX_MALLOC_FREE_END_LOW_TABLE        ; store it (low)
    lda #>ORIX_MALLOC_MAX_MEM_ADRESS
    sta ORIX_MALLOC_FREE_END_HIGH_TABLE       ; store it high
;-orix_end_memory_kernel
    lda #<(ORIX_MALLOC_MAX_MEM_ADRESS-orix_end_memory_kernel) ; Get the size (free)
    sta ORIX_MALLOC_FREE_SIZE_LOW_TABLE                       ; and store
    
    lda #>(ORIX_MALLOC_MAX_MEM_ADRESS-orix_end_memory_kernel) 
    sta ORIX_MALLOC_FREE_SIZE_HIGH_TABLE
  
    lda #$00 ; 0 means One chunk
    sta ORIX_MALLOC_FREE_TABLE_NUMBER
 

; init the malloc pid busy table
    ldx #ORIX_MALLOC_FREE_FRAGMENT_MAX
    lda #$00
.(
loop
    sta ORIX_MALLOC_BUSY_TABLE_PID,x
    dex
    bpl loop
    
.)    

    ; if it's hot reset, then don't initialize current path.
    BIT FLGRST ; COLD RESET ?
    bpl start_prompt	; yes

    ; Setting the current path to "/",0
    lda #"/"
    sta ORIX_PATH_CURRENT

#ifdef CPU_65C02
    stz ORIX_PATH_CURRENT+1
#else
    lda #$00
    sta ORIX_PATH_CURRENT+1 
#endif
    lda #$01                 
    sta ORIX_PATH_CURRENT_POSITION

/****************************************************************************/
start_prompt_and_jump_a_line
    RETURN_LINE
start_prompt
  
#ifdef CPU_65C02
    stz VARAPL               ; Used to store the length of the command line
    stz BUFEDT
    stz ORIX_ARGV
    stz ERRNO
    stz ORIX_CURRENT_PROCESS_FOREGROUND
#else
    lda #$00
    sta VARAPL               ; Used to store the length of the command line
    sta BUFEDT               ; command line buffer
    sta ORIX_ARGV            ; argv buffer
    sta ERRNO                ; errno : last error from command, not managed everywhere
    sta ORIX_CURRENT_PROCESS_FOREGROUND
#endif	

display_prompt
#ifdef CPU_65C02
    stz ORIX_GETOPT_PTR
#else
    lda #$00
    sta ORIX_GETOPT_PTR      ; init the PTR of the command line
#endif
    PRINT(ORIX_PATH_CURRENT) ; Display current path in the prompt
    BRK_ORIX(XECRPR)      ; display prompt (# char)
    SWITCH_ON_CURSOR()

start_commandline
    BRK_ORIX(XRDW0)       ; read keyboard
    bmi start_commandline    ; don't receive any specials chars (that is the case when funct key is used : it needs to be fixed in bank 7 in keyboard management
    cmp #KEY_LEFT
    beq start_commandline    ; left key not managed
    cmp #KEY_RIGHT
    beq start_commandline    ; right key not managed
    cmp #KEY_UP
    beq start_commandline    ; up key not managed
    cmp #KEY_DOWN
    beq start_commandline    ; down key not managed
    cmp #KEY_RETURN          ; is it enter key ?
    bne next_key             ; no we display the char
    lda VARAPL               ; no command ?
    beq start_prompt_and_jump_a_line ; yes it's an empty line
    lda #<BUFEDT             ; register command line buffer
    ldy #>BUFEDT
    jsr _bash                ; and launch interpreter
    lda ORIX_CURRENT_PROCESS_FOREGROUND
    beq start_prompt
    jsr _orix_unregister_process
    jmp start_prompt
next_key	
    cmp #KEY_DEL             ; is it del pressed ?
    beq key_del_routine      ; yes let's remove the char in the BUFEDT buffer
    cmp #KEY_ESC             ; ESC key not managed, but could do autocompletion (Pressed twice)
    beq start_commandline
    ldx VARAPL               ; get the length of the current line
    cpx #MAX_LENGTH_BUFEDT-1 ; do we reach the size of command line buffer ?
    beq start_commandline    ; yes restart command line until enter or del keys are pressed, but
    BRK_ORIX(XWR0)        ; write key on the screen (it's really a key pressed
    ldx VARAPL               ; get the position on the command line
    sta BUFEDT,x             ; stores the char in command line buffer
    inx                      ; increase by 1 the current position in the command line buffer
    stx VARAPL
  
#ifdef CPU_65C02	         
    stz BUFEDT,x             ; flush edition buffer
#else
    lda #$00
    sta BUFEDT,x             ; flush edition buffer
#endif		

    jmp start_commandline    ; and loop interpreter
key_del_routine
    ldx VARAPL               ; load the length of the command line buffer
    beq send_oups_and_loop   ; command line is empty send oups sound
    dex                      ; command line is NOT empty, remove last char in the buffer
    lda #$00                 ; remove last char FIXME 65c02
    sta BUFEDT,x
    stx VARAPL               ; and store the length
    SWITCH_OFF_CURSOR()
    dec SCRX                 ; go one step to the left on the screen

    SWITCH_ON_CURSOR()

no_action	
    jmp start_commandline    ; and restart 

send_oups_and_loop
    BRK_ORIX(XOUPS)
    jmp start_commandline


_bash
.(
    sta RES
    sty RES+1
    jsr ltrim; ltrim command line
    
    ; // Looking if it request ./ : it means that user want to load and execute
    ldy #$00
  loop_space
    lda (RES),y
    cmp #" "
    bne no_more_space 
    iny
    cpy #MAX_LENGTH_BUFEDT
    bne loop_space
  no_command
    rts 
  no_more_space
    cmp #$00
    beq no_command   ;  "     ",0 on command line
    cmp #"."
    bne find_command
    iny
    lda (RES),y
    cmp #"/"
    bne find_command
    
    ; switch off timiers on via2
    lda #0+32+64
    sta V2IER
    
    ; here we jump to command because we founded "./"
    jsr _orix_load_and_start_app
    ; switch on timers en via2
    lda #128+32+64
    sta V2IER
    ; switch on the cursor
    SWITCH_ON_CURSOR()
    rts

find_command
    ; Search command
    ; Insert each command pointer in zpTemp02Word
    ldx #$01
    jsr _orix_get_opt
  
    ldx #$00
loop  
    lda list_command_low,x
    sta RESB
    lda list_command_high,x
    sta RESB+1  
  
  
    ldy #$00
next_char
    lda (RES),y
    cmp (RESB),y        ; same character?
    beq no_space
    cmp #" "            ; space?
    bne command_not_found
    lda (RESB),Y        ; Last character of the command name?
no_space    
    cmp #$00            ; Test end of command name or EOL
    beq command_found
    iny
    bne next_char
 
command_not_found

    inx
    cpx #BASH_NUMBER_OF_COMMANDS 
    bne loop

orix_try_to_find_command_in_bin_path	
	; here we found no command, let's go trying to find it in /bin

    ldx #$00
    jsr _orix_get_opt

    jsr _start_from_root_bin

    cmp #$ff ; if it return x=$ff a=$ff (it's not open)
    beq even_in_slash_bin_command_not_found
    ; we should start code here
    lda #$00
    sta ERRNO
    jsr _orix_load_and_start_app_xopen_done
    rts
even_in_slash_bin_command_not_found	
    RETURN_LINE
    PRINT(ORIX_ARGV)
    PRINT(str_command_not_found)
    lda #$01
    sta ERRNO
    rts

command_found
	; X contains ID of the command
	; Y contains the position of the BUFEDT
    stx TR7                    ; save the id of the command

    RETURN_LINE         ;jump a line
    
    ldx TR7                    ; get the id of the command
    
    lda list_command_low,x     ; get the name of the command
    ldy list_command_high,x    ; and high
    ; get PID father
    ldx ORIX_CURRENT_PROCESS_FOREGROUND
    jsr _orix_register_process ; register process
    bne register_process_valid ; if it's return 0 then there is an error

    ; we manage only max process here, but it could be also a out of memory error
    ; but here we are in a command in ROM, ooe will not arrive except if command do a malloc exception
    ; display maxProcessReached
    PRINT(strMaxProcessReached)
    ; at this step we reach the max process 
    rts 

register_process_valid         ; if we are here, it means that register_process_valid returns a PID
    sta ORIX_CURRENT_PROCESS_FOREGROUND
    
    ldx TR7
    lda commands_low,x
    sta RES
	
    lda commands_high,x
    sta RES+1
    
    JMP (RES) ; be careful with 6502 bug (jmp xxFF)
	
end_string

end

	rts
.)

//  [IN] X get the id of the parameter
// [ IN] Y contains the index in BUFEDT
// Return in AY the ptr of the parameter

ltrim
.(
restart_test_space    
    ldy #$00
    lda (RES),y
    cmp #" "
    beq trimme
    rts
end
#ifdef CPU_65C02
    bra restart_test_space  
#else
    jmp restart_test_space  
#endif  
trimme
    iny ; 1
    lda (RES),y
    dey ; 0
    sta (RES),y
    iny ;1 
    lda (RES),y
    beq end
    bne trimme
    rts
.)

/*
This routine is used to read into /bin directory, and tries to open a binary, if it's Not ok it return in A and X $ffff
*/
_start_from_root_bin
.(
	
    ; copy /bin
    ; do a strcat
    ldx #$00
loop30
    lda str_root_bin,x
    beq end
	
    sta volatile_str,x
    inx
    cpx #SIZE_OF_VOLATILE_STR
    bne loop30
end	
    ldy #$00
loop20
    lda ORIX_ARGV,y
    beq end2
    sta volatile_str,x
    inx
    iny
    cpx #SIZE_OF_VOLATILE_STR
    bne loop20
    ; now copy argv[0]
end2
    sta volatile_str,x

    FOPEN(volatile_str,O_RDONLY)
    /*
    lda #<volatile_str
    ldx #>volatile_str
    ldy #O_RDONLY 
    BRK_ORIX(XOPEN)
    */
    rts
str_root_bin
    .asc "/bin/",0
.)


// Commands
#include "src/orix/commands/banks.asm"
#include "src/orix/commands/basic11.asm"
#include "src/orix/commands/cat.asm"
#include "src/orix/commands/cd.asm"
#include "src/orix/commands/clear.asm"
#include "src/orix/commands/cp.asm"

#ifdef WITH_DF
#include "src/orix/commands/df.asm"
#endif

#include "src/orix/commands/echo.asm"
#include "src/orix/commands/env.asm"

#include "src/orix/commands/help.asm"
#include "src/orix/commands/ioports.asm"
#include "src/orix/commands/kill.asm"
#include "src/orix/commands/less.asm"
#include "src/orix/commands/ls.asm"
#include "src/orix/commands/lscpu.asm"
#include "src/orix/commands/lsmem.asm"
#include "src/orix/commands/lsof.asm"
#include "src/orix/commands/man.asm"
#include "src/orix/commands/meminfo.asm"
#include "src/orix/commands/mkdir.asm"
#include "src/orix/commands/mount.asm"
#include "src/orix/commands/ps.asm"
#include "src/orix/commands/pwd.asm"
#include "src/orix/commands/reboot.asm"
#include "src/orix/commands/rm.asm"
#include "src/orix/commands/sedsd.asm"
#include "src/orix/commands/touch.asm"
#include "src/orix/commands/tree.asm"
#include "src/orix/commands/uname.asm"

#ifdef WITH_SH
#include "src/orix/commands/sh.asm"
#endif

#ifdef WITH_VI
#include "src/orix/commands/vi.asm"
#endif
// Functions


#include "src/orix/commands/viewhrs.asm"
#include "src/orix/commands/xorix.asm"
#include "src/orix/lib/mainargs.asm"
#include "src/orix/lib/strcpy.asm"
#include "src/orix/lib/strcat.asm"
#include "src/orix/lib/strlen.asm"
#include "src/orix/lib/fread.asm"
#include "src/orix/lib/get_opt.asm"
#include "src/orix/lib/getOrixVar.asm"
// hardware
#include "src/include/libs/xa65/ch376.s"
#include "src/include/libs/xa65/ch376_verify.s"


_cd_to_current_realpath_new
.(
    BRK_ORIX(XOPENRELATIVE)
    rts
.)
	
_text
    BRK_ORIX(XTEXT)
    rts

_hires
    BRK_ORIX(XHIRES)
    rts	

_date
    lda #<$bb80+32
    ldy #>$bb80+32
    BRK_ORIX(XWRCLK)
    rts

; FIXME common with telemon
  
_lowercase_char
.(	
    cmp #"A" ; 'a'
    bcc skip
    cmp #"[" ; Found by assinie (bug)
    bcs skip 
    ADC #97-65
skip
    rts
.)
end_crap
    rts
	
_orix_load_and_start_app  
.(
    jsr _ch376_verify_SetUsbPort_Mount
    cmp #$01
    beq end_crap
	
    jsr _cd_to_current_realpath_new
    ldx #$00
    jsr _orix_get_opt
    STRCPY(ORIX_ARGV+2,BUFNOM)
 	
    jsr _ch376_set_file_name
    jsr _ch376_file_open
    cmp #CH376_ERR_MISS_FILE
    bne next
    RETURN_LINE
    PRINT(ORIX_ARGV)
    PRINT(str_command_not_found) ; MACRO
    
    rts	
  
+_orix_load_and_start_app_xopen_done
next
    

		; We need to read 19 bytes
    lda #<volatile_str
    sta PTR_READ_DEST
    lda #>volatile_str
    sta PTR_READ_DEST+1
    lda #20
    ldy #$00
    BRK_ORIX(XFREAD)
    
    lda volatile_str
    cmp #$16
    bne not_a_tape_file
   
    
/******************************************** Manage starting tap file*/	
    ldx #$00
    BRK_ORIX(XCOSCR)

    ; Storing address to load it
    lda volatile_str+11
    sta PTR_READ_DEST
    lda volatile_str+10
    sta PTR_READ_DEST+1
		
    ; init RES to start code
    lda volatile_str+11
    sta VARAPL+2
    lda volatile_str+10
    sta VARAPL+3

    lda #$0E
    ldy #$00
    jsr _ch376_seek_file ; seek to the beginning of the file
    
    
    lda #$ff ; read all the binary
    ldy #$ff
    sei
    jsr _XREAD
    
    jsr _init_basic
    jmp $bfe0



/******************************************** END Manage starting tap file*/	

not_a_tape_file
    cmp #$01
    beq is_an_orix_file
    RETURN_LINE
    
    BRK_ORIX(XCLOSE)
    ; not found it means that we display error message
    ldx #$00
    jsr _orix_get_opt
    PRINT(ORIX_ARGV)

    PRINT(str_cant_execute)
    RETURN_LINE
    ; FIXME close the opened file here

    BRK_ORIX(XCLOSE)
    rts 
is_an_orix_file
    RETURN_LINE	

  	; Switch off cursor
    ldx #$00
    BRK_ORIX(XCOSCR)
    ; Storing address to load it
    lda volatile_str+14
    sta PTR_READ_DEST
    lda volatile_str+15
    sta PTR_READ_DEST+1
		
    ; init RES to start code
    lda volatile_str+18
    sta VARAPL+2
    lda volatile_str+19
    sta VARAPL+3
	
    
    
    ldx #$00
    jsr _orix_get_opt
    
    REGISTER_PROCESS(ORIX_ARGV)
    
    bne register_process_valid ; if it's return 0 then there is an error
    PRINT(strMaxProcessReached)
    ; at this step we reach the max process 
    rts 

register_process_valid         ; if we are here, it means that register_process_valid returns a PID
    sta ORIX_CURRENT_PROCESS_FOREGROUND


    ; detect if it's sedoric file 
    lda volatile_str+7
    beq is_not_encapsulated
    cmp #$01
    bne is_not_sedoric_file

  
    lda #$ff ; read all the binary
    ldy #$ff
    BRK_ORIX(XFREAD)
    sei
    jsr _init_basic
    jsr _sed
    jmp $bfe0

is_not_sedoric_file
is_not_encapsulated  
	
    lda #$ff ; read all the binary
    ldy #$ff
    BRK_ORIX(XFREAD)

    ; These nops are used because on real hardware, CLOSE refuse to close
   
    lda #$00 ; don't update length
    BRK_ORIX(XCLOSE)

    jmp (VARAPL+2) ; jmp : it means that if program launched do an rts, it returns to interpreter
		
end

.)	

switch_off        
.byt $EA,$00,$00,$00,$00,$00,$00,$EF,$00,$00,$00,$00,$00,$00

_XREAD
#include "src/functions/xread.asm"


_init_basic
.(   
    ldx #$00
.(
loop
    lda _sedoric_start_code_copy,x
    sta $bfe0,x
    inx
    cpx #$10
    bne loop

.)
                        ; FC00 78                       x
    cld                                     ; FC01 D8                       .
    lda     #$FF                            ; FC05 A9 FF                    ..
    sta     V1DDRA                          ; FC07 8D 03 03                 ...
    lda     #$F7                            ; FC0A A9 F7                    ..
    sta     V1DDRB                          ; FC0C 8D 02 03                 ...
    lda     #$7F                            ; FC17 A9 7F                    ..
    sta     V2IFR                           ; FC19 8D 2D 03                 .-.
    sta     V1IFR                           ; FC1C 8D 0D 03                 ...


    lda     #<10000
    sta     $306
    lda     #>10000
    sta     $307
    
    lda     #$02                            ; FC1F A9 02                    ..
    sta     $031E                           ; FC21 8D 1E 03                 ...
    
        
    lda     #$07                            ; FC24 A9 07                    ..
    ldx     #$40                            ; FC26 A2 40                    .@
    jsr     INIT_VIA1                       ; FC28 20 FC FD                  ..

    ldx     #$00
.(
loop
    lda     page0,x
    sta     $00
    lda     page2,x
    sta     $200,x
    inx
    bne     loop
    lda     #$00
    sta     $500
    sta     $501
    sta     $502
    
    rts
.)

page0
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$70,$f7,$00,$b8
.byt $00,$03,$c0,$bc,$00,$00,$00,$00,$00,$00,$4c,$b0,$cc,$00,$00,$00
.byt $00,$4c,$36,$d3,$22,$22,$00,$ff,$ff,$00,$00,$00,$00,$00,$00,$00
.byt $02,$28,$28,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $ff,$ff,$ff,$ff,$ff,$88,$85,$00,$0a,$b2,$c3,$ff,$ff,$ff,$ff,$ff
.byt $ff,$b2,$c3,$ab,$e0,$ff,$ff,$ff,$ff,$ff,$01,$05,$03,$05,$03,$05
.byt $03,$05,$00,$98,$ff,$ff,$00,$98,$ff,$ff,$ff,$ff,$ff,$00,$ff,$ff
.byt $00,$05,$ff,$ff,$ff,$ff,$24,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$03,$4c,$ff,$00,$ff,$ff,$ff,$ff,$ff,$ff,$fc,$00,$ff,$ff
.byt $0a,$b2,$c3,$88,$00,$20,$ff,$00,$80,$00,$00,$00,$04,$00,$b2,$00
.byt $bc,$c3,$e6,$e9,$d0,$02,$e6,$ea,$ad,$00,$05,$c9,$20,$f0,$f3,$20
.byt $b9,$ec,$60,$2c,$60,$ea,$2c,$60,$ea,$60,$80,$4f,$c7,$52,$ff,$00
page1
.byt $20,$33,$37,$36,$33,$31,$00,$30,$30,$30,$30,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$fe,$31,$66,$fe,$31
.byt $66,$fe,$31,$66,$f5,$07,$38,$f5,$ff,$c8,$f4,$03,$32,$01,$6f,$ee
.byt $0a,$00,$40,$2f,$ee,$00,$62,$88,$e8,$c5,$72,$96,$c5,$bc,$c4,$00



page2
.byt $00,$00,$00,$00,$00,$00,$00,$00,$38,$38,$00,$00,$ff,$f8,$20,$00
.byt $00,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$00,$00,$00,$00,$00,$00,$00,$4c,$7c,$f7,$4c,$78,$eb,$4c,$c1
.byt $f5,$4c,$65,$f8,$4c,$22,$ee,$4c,$b2,$f8,$40,$00,$00,$00,$20,$04
.byt $00,$01,$00,$02,$00,$00,$50,$28,$00,$00,$00,$00,$00,$00,$00,$00
.byt $00,$63,$f6,$00,$00,$80,$00,$00,$08,$02,$03,$17,$00,$00,$00,$00
.byt $00,$01,$01,$00,$07,$00,$48,$fe,$d0,$bb,$a8,$bb,$10,$04,$1b,$00
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $02,$00,$98,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$00
.byt $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
.byt $ff,$7f,$00,$ff,$7f,$36,$d3,$ff,$10,$ff,$ff,$4c,$36,$d3,$ff,$ff
.byt $00,$00,$f7,$ff,$00,$00,$10,$27,$00,$00,$00,$40,$dd,$00,$40,$00


irq
.byt $4c,$22,$ee
.byt $4c,$b2,$f8
.byt $40

INIT_VIA1:
    sta     V1DRA                           ; FDFC 8D 01 03                 ...
    lda     #$EE                            ; FDFF A9 EE                    ..
    sta     V1PCR                           ; FE01 8D 0C 03                 ...
    lda     #$CC                            ; FE04 A9 CC                    ..
    sta     V1PCR                           ; FE06 8D 0C 03                 ...
    stx     V1DRAB                          ; FE09 8E 0F 03                 ...
    lda     #$EC                            ; FE0C A9 EC                    ..
    sta     V1PCR                           ; FE0E 8D 0C 03                 ...
    lda     #$CC                            ; FE11 A9 CC                    ..
    sta     V1PCR                           ; FE13 8D 0C 03                 ...
    rts 

.)

_sedoric_start_code_copy
    sei
    lda #ATMOS_ID_BANK
    sta V2DRA

    cli    
    jmp (VARAPL+2) ; jmp : it means that if program launched do an rts, it returns to interpreter
    
_sed
.(  
#define BASIC11_IRQ_VECTOR_ROM $ee22
    lda     #<BASIC11_IRQ_VECTOR_ROM                            ; FC81 A9 22                    ."
    ldy     #>BASIC11_IRQ_VECTOR_ROM                            ; FC83 A0 EE                    ..
    sta     $08                           ; FC85 85 08                    ..
    sty     $09                             ; FC87 84 09                    ..
    lda     #$06                            ; FC89 Atmos bank
    ldy     #$80                            ; FC8B A0 80                    ..
LFC8D:
    sty     $00                             ; FC8D 84 00                    ..
    sta     $01                             ; Store 6 in $01, it will be used to start ATMOS ROM
    sta     $1C                             ; FC91 85 1C                    ..
    sta     $0247                           ; FC93 8D 47 02                 .G.   
    
    rts
.)

_getcpu:
.(
        lda     #$00
        .byt    $1A        ; .byte $1A ; nop on nmos, "inc A" every cmos
        cmp     #$01
        bne     is6502Nmos
        lda     #ID_CPU_65C02       ; it's a 65C02
        rts
is6502Nmos        
        lda     #ID_CPU_6502
        rts
.)

_debug
.(
;CPU_6502
    ; routine used for some debug
    PRINT(str_cpu)
    jsr     _getcpu
    cmp     ID_CPU_65C02
    bne     is6502
    PRINT(str_65C02)
   ; bra     next        ; At this step we are sure that it's a 65C02, so we use its opcode :)
is6502
    PRINT(str_6502)
 
next    
    PRINT(str_ch376)
    jsr     _ch376_ic_get_ver
    BRK_ORIX(XWR0)
   
    RETURN_LINE  
    
    PRINT(str_ch376_check_exist)
    jsr  _ch376_check_exist
    jsr  _print_hexa
    RETURN_LINE
    
    lda #$09
    ldy #$02
  
    BRK_ORIX(XMALLOC)
    ; A & Y are the ptr here
   ; BRK_ORIX(XFREE)
    
    rts

    
str_ch376:
    .asc "CH376 VERSION : ",0
str_ch376_check_exist:
    .asc "CH376 CHECK EXIST : ",0    
str_cpu:    
    .asc "CPU: ",0
.)	

_print_hexa:
    pha
    CPUTC("#")
    pla

    BRK_ORIX(XHEXA)
    sty TR7
    
    BRK_ORIX(XWR0)
    lda TR7
    BRK_ORIX(XWR0)
    rts
   

_print_hexa_no_sharp:

    BRK_ORIX(XHEXA)
    sty TR7
    
    BRK_ORIX(XWR0)
    lda TR7
    BRK_ORIX(XWR0)
    rts   



;*****************************************************

commands_low
    .byt <_basic11
    .byt <_banks    
    .byt <_cat
    .byt <_cd
    .byt <_clear ; 
    .byt <_cp
    
#ifdef WITH_DF
    .byt <_df
#endif    

    .byt <_echo ; 
    .byt <_env
    .byt <_ls ; dir (alias)
    .byt <_date 
    .byt <_help ;
    .byt <_ioports ;    

#ifdef WITH_LESS
    .byt <_less
#endif    
    
    .byt <_ls
    .byt <_lscpu
    .byt <_lsmem

#ifdef WITH_LSOF
    .byt <_lsof
#endif

    .byt <_man
    .byt <_meminfo
    .byt <_mkdir
    .byt <_mv ; is in _cp
    
#ifdef WITH_MOUNT
    .byt <_mount
#endif    

    .byt <_ps
    .byt <_pwd
    .byt <_rm

#ifdef WITH_SEDSD
    .byt <_sedsd
#endif     
    
#ifdef WITH_SH
    .byt <_sh
#endif    

    .byt <_touch
    .byt <_uname
    
#ifdef WITH_VI
    .byt <_vi
#endif


    .byt <_viewhrs
    .byt <_reboot	
    .byt <_debug	
    
#ifdef WITH_XORIX
    .byt <_xorix
#endif	
  
commands_high
    .byt >_basic11
    .byt >_banks    
    .byt >_cat
    .byt >_cd
    .byt >_clear
    .byt >_cp
   
#ifdef WITH_DF
    .byt >_df
#endif        

    .byt >_echo
    .byt >_env
    .byt >_ls ; alias()
    .byt >_date ; alias()
    .byt >_help
    .byt >_ioports    

#ifdef WITH_LESS
    .byt >_less
#endif        

    .byt >_ls
    .byt >_lscpu
    .byt >_lsmem
    
#ifdef WITH_LSOF    
    .byt >_lsof
#endif    
    .byt >_man
    .byt >_meminfo
    .byt >_mkdir
    .byt >_mv
#ifdef WITH_MOUNT
    .byt >_mount
#endif        
    .byt >_ps
    .byt >_pwd
    .byt >_rm

#ifdef WITH_SEDSD
    .byt >_sedsd
#endif  
    
#ifdef WITH_SH
    .byt >_sh
#endif  
  
    .byt >_touch
    .byt >_uname

#ifdef WITH_VI
    .byt >_vi
#endif
	

    .byt >_viewhrs
    .byt >_reboot
    .byt >_debug	

#ifdef WITH_XORIX
    .byt >_xorix
#endif	
    
list_command_low
    .byt <basic11
    .byt <banks    
    .byt <cat
    .byt <cd
    .byt <clear
    .byt <cp
   
#ifdef WITH_DF
    .byt <df
#endif        

    .byt <echocmd
    .byt <env
    .byt <dir
    .byt <date
    .byt <help
    .byt <ioports    
    
#ifdef WITH_LESS
    .byt <less
#endif   
    
    .byt <ls
    .byt <lscpu
    .byt <lsmem
    
#ifdef WITH_LSOF
    .byt <lsof
#endif    

    .byt <man
    .byt <meminfo
    .byt <mkdir
    .byt <mv
#ifdef WITH_MOUNT
    .byt <mount
#endif        
    .byt <ps
    .byt <pwd
    .byt <rm

#ifdef WITH_SEDSD
    .byt <sedoric
#endif     
    
#ifdef WITH_SH
    .byt <sh
#endif

    .byt <touch
    .byt <uname

#ifdef WITH_VI
    .byt <vi
#endif    
  
    .byt <viewhrs
    .byt <reboot
    .byt <debug

#ifdef WITH_XORIX
    .byt <xorix
#endif	
    
list_command_high
    .byt >basic11
    .byt >banks    
    .byt >cat
    .byt >cd
    .byt >clear
    .byt >cp
    
#ifdef WITH_DF
    .byt >df
#endif        

    .byt >echocmd
    .byt >env
    .byt >dir
    .byt >date
    .byt >help
    .byt >ioports    
    
#ifdef WITH_LESS
    .byt >less
#endif    
    .byt >ls
    .byt >lscpu
    .byt >lsmem
  
#ifdef WITH_LSOF    
    .byt >lsof
#endif

    .byt >man
    .byt >meminfo
    .byt >mkdir
    .byt >mv
#ifdef WITH_MOUNT
    .byt >mount
#endif            
    .byt >ps
    .byt >pwd
    .byt >rm
#ifdef WITH_SEDSD
    .byt >sedoric
#endif 
#ifdef WITH_SH
    .byt >sh
#endif
    .byt >touch
    .byt >uname    
#ifdef WITH_VI
    .byt  >vi
#endif

    .byt >viewhrs
    .byt >reboot
    .byt >debug

#ifdef WITH_XORIX
    .byt >xorix
#endif	

commands_length
    .byt 7 ; _basic11
    .byt 4 ; _banks
    .byt 3 ; _cat
    .byt 2 ; _cd
    .byt 5 ; _clear ; 
    .byt 2 ; _cp
#ifdef WITH_DF    
    .byt 2 ; _df ;     
#endif    
    .byt 4 ; _echo ; 
    .byt 3
    .byt 3 ; _ls ; dir (alias)
    .byt 4 ; _date 
    .byt 4 ; _help ; 
    .byt 7 ; _ioports
#ifdef WITH_LESS
    .byt 4 ;_less
#endif        
    .byt 2 ; _ls
    .byt 5
    .byt 5 ; lsmem

#ifdef WITH_LSOF
    .byt 4 ; lsof
#endif

    .byt 3 ; man
    .byt 7 ; meminfo
    .byt 5 ; _mkdir
    .byt 2 ; mv
#ifdef WITH_MOUNT
    .byt 5 ; mount
#endif            
    .byt 2 ; ps
    .byt 3 ; _pwd
    .byt 2 ; rm

#ifdef WITH_SEDSD
    .byt 7
#endif     
    
#ifdef WITH_SH
    .byt 2 ; sh
#endif   

    .byt 5 ; touch
    .byt 5 ;_uname
    
#ifdef WITH_VI
    .byt 2
#endif

    .byt 7
    .byt 6 ;_reboot	
    .byt 5 ;_debug	

#ifdef WITH_XORIX
    .byt 5 ;xorix
#endif	    
    
basic11
    .asc "basic11",0
banks
    .asc "bank",0    
cat
    .asc "cat",0    
cd
    .asc "cd",0    
clear
    .asc "clear",0    
cp 
    .asc "cp",0
date
    .asc "date",0    
df
    .asc "df",0        
dir
    .asc "dir",0    
echocmd
    .asc "echo",0
env
    .asc "env",0 
help
    .asc "help",0
history
    .asc "history",0    
ioports
    .asc "ioports",0
kill
    .asc "kill",0
less	
    .asc "less",0    
ls	
    .asc "ls",0
lscpu
    .asc "lscpu",0
lsmem	
    .asc "lsmem",0
lsof	
    .asc "lsof",0
man
    .asc "man",0    
meminfo
    .asc "meminfo",0
mkdir
    .asc "mkdir",0
mv
    .asc "mv",0
mount
    .asc "mount",0    
rm
    .asc "rm",0
ps
    .asc "ps",0
pwd
    .asc "pwd",0
reboot
    .asc "reboot",0
sedoric
    .asc "sedoric",0
sh
    .asc "sh",0
tree
    .asc "tree",0
touch
    .asc "touch",0
uname
    .asc "uname",0
vi
    .asc "vi",0
viewhrs
    .asc "viewhrs",0
xorix
    .asc "xorix",0    
debug
    .asc "debug",0
   
str_6502:                           ; use for lscpu
    .asc "6502",0
str_65C02:                          ; use for lscpu
    .asc "65C02",0    
strMaxProcessReached
    .asc "Max Process reached : "
    .byt ORIX_MAX_PROCESS+32+8+8
    .byt $0D,$0A,0
str_tape_file
    .asc "Tape file : not working yet",0
str_cant_execute
    .asc ": is not an Orix file",0
str_press_a_key	
    .asc "Type cload",34," when you are in atmos mode. Press ESC to escape, press a key to start",0
str_basic	
    .asc "BASIC",0	
str_assembly	
    .asc "ASSEMBLY",0	
str_not_found	
    .asc " : No such file or directory",$0D,$0A,0
str_missing_operand
    .asc ": missing operand",$0d,$0a,0
; used by uname
str_os	
    .asc "Orix",0
str_command_not_found
    .asc ": command not found",$0a,$0d,0
txt_file_not_found
    .asc "File not found :",0
	

#ifndef  __DATEBUILT__
#define __DATEBUILT__ "10/09/2016"
#endif
str_compile_time
    .asc "Build : ","__DATEBUILT__"," "
	
#ifdef CPU_65C02
cpu_build
    .asc "65C02",0
#else
cpu_build
    .asc "6502",0
#endif

; [IN] X the id of_orix_register_process the command
process_init
    .asc "init",0
process_bash
    .asc "bash",0

_orix_register_process
.(
    ; IN X contains the pid father
    ; IN [A & Y] the string of the command
    ; OUT [A contains the PID]
    ; get available PID
    sta     RES ; save A
    sty     RES+1
; get the next PID available    
.(
    ldx     #$00
loop
    lda     LIST_PID,x
    beq     isFree
    inx     
    cpx     #ORIX_MAX_PROCESS
    bne     loop

    lda     #$00                 ; Error 
    rts
.)    
isFree
    ; looking for the next PID
    txa
    pha


    lda     #$01
    sta     TR4
    
.(
    ldx     #$00
loop
    lda     LIST_PID,x
    cmp     TR4
    bne     next
    inc     TR4

next    
    inx     
    cpx     #ORIX_MAX_PROCESS
    bne     loop    
   .) 
  
    pla
    tax
  
    ; Register process into ps table  
   

    lda orix_command_table_low,x  ;store in process list
    sta RESB
    lda orix_command_table_high,x
    sta RESB+1
    jsr _strcpy
    
    stx RES ; save the position     

    lda  TR4
    ldx  RES
    sta  LIST_PID,x ; register 
    ldx  TR4

 
    rts
.)
orix_command_table_low
    .byt <LIST_NAME_PID
    .byt <LIST_NAME_PID+9
    .byt <LIST_NAME_PID+9*2
    .byt <LIST_NAME_PID+9*3
    .byt <LIST_NAME_PID+9*4
    .byt <LIST_NAME_PID+9*5
orix_command_table_high
    .byt >LIST_NAME_PID
    .byt >LIST_NAME_PID+9  
    .byt >LIST_NAME_PID+9*2   
    .byt >LIST_NAME_PID+9*3
    .byt >LIST_NAME_PID+9*4
    .byt >LIST_NAME_PID+9*5


str_orix
signature
.asc  "Orix - __DATEBUILT__",$00    
    

_orix_unregister_process
.(
; [A] id of the process

  ldx #$00                    
loop  
  cmp LIST_PID,x               ; looking un ps table where the PID is
  beq found
  inx
  cpx #ORIX_NUMBER_OF_MALLOC
  bne loop
  ; not found
  rts
  
  ; at this step X contains the position of the ps list    
found
  pha                           ; save PID
  lda #$00  ; FIXME 65C02  
  sta LIST_PID,x                ; destroy the PID in ps table
  ; destroy busy chunks of this process
 
  
  ; let's trying to find malloc done for this process
  pla ; get PID

  ldx #$00
loop_free_process
  cmp ORIX_MALLOC_BUSY_TABLE_PID,x
  bne next_chunk
free_chunk
#ifdef WITH_DEBUG
; in debug mode we keep malloc table
#else  
  ; save A, X and call XFREE
  pha
  txa
  pha

  lda ORIX_MALLOC_BUSY_TABLE_BEGIN_LOW,x
  ldy ORIX_MALLOC_BUSY_TABLE_BEGIN_HIGH,x
  BRK_ORIX(XFREE)
  ; and flush

  pla
  tax
  ; and clean pid 
  lda #$00
  sta ORIX_MALLOC_BUSY_TABLE_PID,x
  pla
#endif 

next_chunk  
  inx
  cpx #ORIX_NUMBER_OF_MALLOC
  bne loop_free_process
  rts
 ; TODO destroy fp from this process
.)

_orix_init_filehandle
.(
    lda #$02 ; stdin/stdout/sderr
    sta NUMBER_OPENED_FILES
    rts
.)	

; [out] A=#ff if error, else X contains the id of the filehandle
_orix_register_filehandle
.(

    ldx NUMBER_OPENED_FILES
    cpx #ORIX_MAX_OPEN_FILES
    beq error
    inc NUMBER_OPENED_FILES
    lda #$00
    rts
error
    lda #$00
    rts
.)	

_orix_unregister_filehandle
.(
    rts
.)

ORIX_ROUTINES_TABLE
ORIX_ROUTINES_TABLE_LOW
    .byt <_orix_register_filehandle ;0
    .byt <_orix_register_process    ;1 
    .byt <_orix_unregister_process  ;2

ORIX_ROUTINES_TABLE_HIGH
    .byt >_orix_register_filehandle
    .byt >_orix_register_process
    .byt >_orix_unregister_process

end_all

    

    .dsb $ffff-end_all-16-15,0 ; 5 because we have 5 bytes after

*=$ffe0
_call_orix_routine
.(

    ldx TR0
    lda ORIX_ROUTINES_TABLE_LOW,x
    sta RES
    lda ORIX_ROUTINES_TABLE_HIGH,x
    sta RES+1
    jmp (RES)
.)


#ifdef NOTROM
#else	
free_bytes ; 26 bytes
    .dsb $ffff-free_bytes-7,0 ; 5 because we have 5 bytes after

; fffa
END_ROM
copyright
    .byt <str_orix
    .byt >str_orix
    
version_bank
    .byt $00

;$fffb
status_bank
    .byt %11101111 ;
; fffc
RESET:
    .byt <start_orix,>start_orix
; fffe
BRK_IRQ:	
    .byt <VIRQ,>VIRQ	
#endif	
	
