; ----------------------------------------------------------------------------
; Orix.s:
; ----------------------------------------------------------------------------
;				Compatibilité Orix: exec
; ----------------------------------------------------------------------------

.ifdef With::ORIX

	.ifndef Included::ORIX_INC
		Included::ORIX_INC = 1
		verbose 3, "Ajout compatibilité Orix (exec)"


		; ----------------------------------------------------------------------------
		; Compatibilité Orix: exec
		; ----------------------------------------------------------------------------
		commands_list:
		        .asciiz "forth"

		commands_address:
			.addr ORIGIN

		commands_address_end:

	.else
		; verbose 3, "Ajout vecteurs Orix (exec)"

		; ----------------------------------------------------------------------------
		;
		; ----------------------------------------------------------------------------
		.if * > $fff0
			.error .sprintf("Erreur fichier trop long %d", _err_)
		.endif
		.res $fff0-*, $00
			; $fff0
			.byte $01 ; command ROM
			; $fff1
			.byte $00 ; Used in the future
			; $fff2
			.byte $00 ; Used in the future
	
		; ----------------------------------------------------------------------------
		; Vecteurs Orix
		; ----------------------------------------------------------------------------
				; $fff3/f4
		        .addr   commands_address
				; $fff5/f6
		        .addr   commands_list
				; $fff7
		        .byte   (commands_address_end - commands_address)>>1

		; ----------------------------------------------------------------------------
		; Vecteurs 6502 & Telemon
		; ----------------------------------------------------------------------------
			; $fff8/f9
	        .word   teleforth_signature

		; ----------------------------------------------------------------------------
		; NMI
		; ----------------------------------------------------------------------------
		; $fffa/fb
		.addr   ORIGIN
		; ----------------------------------------------------------------------------
		; RESET
		; ----------------------------------------------------------------------------
			; $fffc/fd
	        .word   ORIGIN
		; ----------------------------------------------------------------------------
		; IRQ
		; ----------------------------------------------------------------------------
			; $fffe/ff
	    	.word   virq
	.endif

.endif

