; ----------------------------------------------------------------------------
; Sounds.s:
; ----------------------------------------------------------------------------
;				Vocabulaire SOUNDS
; ----------------------------------------------------------------------------

.ifdef With::SOUNDS_VOC

	.ifdef Included::SOUNDS
		verbose 3, "Ajout entête du vocabulaire SOUNDS"

		; ----------------------------------------------------------------------------
		; SOUNDS
		; ----------------------------------------------------------------------------
		vocabulary_pfa "SOUNDS"

	.else
		verbose 3, "Ajout du dictionaire SOUNDS"
		Included::SOUNDS = 1

		; ----------------------------------------------------------------------------
		; SOUNDS
		; ----------------------------------------------------------------------------
		vocabulary "SOUNDS",, immediate

		; ----------------------------------------------------------------------------
		; PSG:
		; ----------------------------------------------------------------------------
		declare "PSG:", "PSGCOL"
		        .word   DOCOL
		        .word   CREATE
		        .word   HERE
		        .word   LIT
		        .word   $0E
		        .word   ALLOT
		        .word   HERE
		        .word   PDO
		LE32D:
		        .word   I
		        .word   ONES
		        .word   CSTORE
		        .word   LIT
		        .word   $FFFF
		        .word   PPLOOP
		        .word   LE32D
		        .word   PSEMICODE

		        stx     _XSAVE
		        ldy     #$02
		        lda     (W),y
		        tax
		        iny
		        lda     (W),y
		        tay
		        brk
		        .byte   XSONPS                    ; Telemon
		        ldx     _XSAVE
		        jmp     NEXT

		; ----------------------------------------------------------------------------
		; PSG!
		; ----------------------------------------------------------------------------
		declare "PSG!", "PSGSTORE"
		        .word   DOCOL
		        .word   AYX
		        .word   TWOP
		        .word   CSTORE
		        .word   LIT
		        .word   XEPSG
		        .word   MON
		        .word   SEMIS

		; ----------------------------------------------------------------------------
		; PLAY
		; ----------------------------------------------------------------------------
		declare "PLAY"
		        .word   DOHRS
		        .byte   $43,$04

		; ----------------------------------------------------------------------------
		; SOUND
		; ----------------------------------------------------------------------------
		declare "SOUND"
		        .word   DOHRS
		        .byte   $44,$03

		; ----------------------------------------------------------------------------
		; MUSIC
		; ----------------------------------------------------------------------------
		declare "MUSIC"
		        .word   DOHRS
		        .byte   $45,$04

		; ----------------------------------------------------------------------------
		; OUPS
		; Appel Telemon XOUPS ($42)
		; ----------------------------------------------------------------------------
		declare "OUPS"
		        .word   DOMON
		        .byte   XOUPS

		; ----------------------------------------------------------------------------
		; ZAP
		; Appel Telemon XZAP ($46)
		; ----------------------------------------------------------------------------
		declare "ZAP"
		        .word   DOMON
		        .byte   XZAP

		; ----------------------------------------------------------------------------
		; SHOOT
		; Appel Telemon XSHOOT ($47)
		; ----------------------------------------------------------------------------
		declare "SHOOT"
		        .word   DOMON
		        .byte   XSHOOT

		; ----------------------------------------------------------------------------
		; EXPLODE
		; Appel Telemon XEXPLO ($9C)
		; ----------------------------------------------------------------------------
		declare "EXPLODE"
		        .word   DOMON
		        .byte   XEXPLO

		; ----------------------------------------------------------------------------
		; PING
		; Appel Telemon XPING ($9D)
		; ----------------------------------------------------------------------------
		declare "PING"
		        .word   DOMON
		        .byte   XPING

	.endif

.endif

